{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 2003-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.NetActivator platform experimental;

{$T-,H+,X+}

interface

uses
  Borland.VCL.Classes,
  System.Windows.Forms;

{ TNetObjectActivator }
  
type
  TNetObjectActivator = class(TObject)
  private
    FOwner: TObject;
    FObj: System.Object;
    FOnActivate: TNotifyEvent;
    function GetActive: boolean;
  public
    constructor Create(AOwner: TObject);
    function Activate(AObject: System.Object): boolean; overload;
    function Activate(AObjectType: System.Type): boolean; overload;
    function Activate(const AAssemblyName, AObjectName: string): boolean; overload;
    procedure Clear;
    property Owner: TObject read FOwner;
    property Obj: System.Object read FObj;
    property Active: boolean read GetActive;
    property OnActivate: TNotifyEvent read FOnActivate write FOnActivate;
  end;

{ TNetControlActivator }
  
  TNetControlActivator = class(TObject)
  private
    FObjActivator: TNetObjectActivator;
    FOnActivate: TNotifyEvent;
    function GetActive: boolean;
    function GetControl: System.Windows.Forms.Control;
    function GetOwner: TObject;
    procedure OnObjActivate(Sender: TObject);
  public
    constructor Create(AOwner: TObject);
    destructor Destroy; override;
    function Activate(AControl: System.Windows.Forms.Control): boolean; overload;
    function Activate(AControlType: System.Type): boolean; overload;
    function Activate(const AAssemblyName, AControlName: string): boolean; overload;
    procedure Clear;
    property Owner: TObject read GetOwner;
    property Control: System.Windows.Forms.Control read GetControl;
    property Active: boolean read GetActive;
    property OnActivate: TNotifyEvent read FOnActivate write FOnActivate;
  end;
  
implementation

uses
  Borland.Vcl.Forms,
  System.Reflection,
  System.Runtime.Remoting;
  
{ TNetObjectActivator } 

constructor TNetObjectActivator.Create(AOwner: TObject); 
begin
  inherited Create;
  FOwner := AOwner; 
end;
  
function TNetObjectActivator.GetActive: boolean;
begin
  Result := FObj <> nil;
end;

procedure TNetObjectActivator.Clear;
begin
  FObj := nil;
end;

function TNetObjectActivator.Activate(AObject: System.Object): boolean;
begin
  FObj := AObject;
  Result := Self.GetActive;
  
  if Assigned(FOnActivate) then
    FOnActivate(Self);
end;

function TNetObjectActivator.Activate(AObjectType: System.Type): boolean;
begin
  FObj := Activator.CreateInstance(AObjectType);
  Result := Self.GetActive;
  
  if Assigned(FOnActivate) then
    FOnActivate(Self);
end;

function TNetObjectActivator.Activate(const AAssemblyName, AObjectName: string): boolean;
var
  vAssembly: System.Reflection.Assembly;
  vType: System.Type;
begin
  Result := False;
  vAssembly := System.Reflection.Assembly.LoadWithPartialName(AAssemblyName);
  if vAssembly = nil then
    Exit;
  vType := vAssembly.GetType(AObjectName);
  Result := Self.Activate(vType);
end;

{ TNetControlActivator }

procedure TNetControlActivator.OnObjActivate(Sender: TObject);
begin
  if Assigned(FOnActivate) then
    FOnActivate(Self);
end;

constructor TNetControlActivator.Create(AOwner: TObject);
begin
  inherited Create;
  FObjActivator := TNetObjectActivator.Create(AOwner);
  FObjActivator.OnActivate := Self.OnObjActivate;
end;

destructor TNetControlActivator.Destroy;
begin
  FObjActivator.Free;
  inherited Destroy;
end;

function TNetControlActivator.GetActive: boolean;
begin
  Result := FObjActivator.Active;
end;

function TNetControlActivator.GetControl: System.Windows.Forms.Control;
begin
  Result := System.Windows.Forms.Control(FObjActivator.Obj);
end;

procedure TNetControlActivator.Clear;
begin
  FObjActivator.Clear;
end;

function TNetControlActivator.Activate(AControl: System.Windows.Forms.Control): boolean;
begin
  Result := FObjActivator.Activate(System.Object(AControl));
end;

function TNetControlActivator.Activate(AControlType: System.Type): boolean;
begin
  Result := FObjActivator.Activate(AControlType);
end;

function TNetControlActivator.Activate(const AAssemblyName, AControlName: string): boolean;
begin
  Result := FObjActivator.Activate(AAssemblyName, AControlName);
end;

function TNetControlActivator.GetOwner: TObject;
begin
  Result := FObjActivator.Owner;
end;

end.

